/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.commands.citizencommands;

import com.ldtteam.structurize.util.LanguageHandler;
import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.minecolonies.coremod.commands.commandTypes.IMCColonyOfficerCommand;
import com.minecolonies.coremod.commands.commandTypes.IMCCommand;
import com.mojang.brigadier.Command;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.Optional;
import net.minecraft.command.CommandSource;
import net.minecraft.command.arguments.ILocationArgument;
import net.minecraft.command.arguments.Vec3Argument;
import net.minecraft.entity.Entity;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;

public class CommandCitizenTriggerWalkTo
implements IMCColonyOfficerCommand {
    @Override
    public int onExecute(CommandContext<CommandSource> context) {
        Entity sender = ((CommandSource)context.getSource()).func_197022_f();
        int colonyID = IntegerArgumentType.getInteger(context, (String)"colonyID");
        IColony colony = IColonyManager.getInstance().getColonyByDimension(colonyID, (RegistryKey<World>)(sender == null ? World.field_234918_g_ : ((CommandSource)context.getSource()).func_197023_e().func_234923_W_()));
        if (colony == null) {
            ((CommandSource)context.getSource()).func_197030_a((ITextComponent)LanguageHandler.buildChatComponent((String)"com.minecolonies.command.colonyidnotfound", (Object[])new Object[]{colonyID}), true);
            return 0;
        }
        ICitizenData citizenData = colony.getCitizenManager().getCivilian(IntegerArgumentType.getInteger(context, (String)"citizenID"));
        if (citizenData == null) {
            ((CommandSource)context.getSource()).func_197030_a((ITextComponent)LanguageHandler.buildChatComponent((String)"com.minecolonies.command.citizeninfo.notfound", (Object[])new Object[0]), true);
            return 0;
        }
        Optional<AbstractEntityCitizen> optionalEntityCitizen = citizenData.getEntity();
        if (!optionalEntityCitizen.isPresent()) {
            ((CommandSource)context.getSource()).func_197030_a((ITextComponent)LanguageHandler.buildChatComponent((String)"com.minecolonies.command.citizeninfo.notloaded", (Object[])new Object[0]), true);
            return 0;
        }
        AbstractEntityCitizen entityCitizen = optionalEntityCitizen.get();
        ILocationArgument targetLocation = Vec3Argument.func_200385_b(context, (String)"location");
        BlockPos targetPos = targetLocation.func_197280_c((CommandSource)context.getSource());
        if (((CommandSource)context.getSource()).func_197023_e() == entityCitizen.field_70170_p) {
            entityCitizen.getNavigation().func_75492_a(targetPos.func_177958_n(), targetPos.func_177956_o(), targetPos.func_177952_p(), 1.0);
        }
        return 1;
    }

    @Override
    public String getName() {
        return "walk";
    }

    @Override
    public LiteralArgumentBuilder<CommandSource> build() {
        return (LiteralArgumentBuilder)IMCCommand.newLiteral(this.getName()).then(IMCCommand.newArgument("colonyID", IntegerArgumentType.integer((int)1)).then(IMCCommand.newArgument("citizenID", IntegerArgumentType.integer((int)1)).then(IMCCommand.newArgument("location", Vec3Argument.func_197301_a()).executes(this.executePreConditionCheck().then((Command<CommandSource>)((Command)this::onExecute))))));
    }
}

